model ExternalFunctions

  function f
    input Real x;
	input Real y;
	output Real u;
	external "C" u = myC(x, y);
	annotation(Include="
	#include <stdio.h>
	
	double myC(double x, double y)
	{
	  return x + y;
	}
	");
  end f;

  Real x(start = 1, fixed=true);
equation
  der(x) = -f(x, time) * x;
end ExternalFunctions;

